import type { IRow, IMutField } from '@kanaries/graphic-walker/interfaces';
import type { IDarkMode, IThemeKey } from '@kanaries/graphic-walker/interfaces';
export interface IAppProps {
    fieldkeyGuard: boolean;
    themeKey: IThemeKey;
    dark: IDarkMode;
    dataSource: IRow[];
    rawFields: IMutField[];
    id: string;
    dataSourceProps: IDataSourceProps;
    version?: string;
    hashcode?: string;
    visSpec: any;
    userConfig?: IUserConfig;
    env?: string;
    needLoadDatas?: boolean;
    specType: string;
    showCloudTool: boolean;
    needInitChart: boolean;
    useKernelCalc: boolean;
    useSaveTool: boolean;
    parseDslType: "server" | "client";
    communicationUrl: string;
    gwMode: "explore" | "renderer" | "filter_renderer" | "table";
    needLoadLastSpec: boolean;
    extraConfig?: any;
    fieldMetas: any;
    isExportDataFrame: boolean;
    defaultTab: "data" | "vis";
}
export interface IDataSourceProps {
    tunnelId: string;
    dataSourceId: string;
}
export interface IUserConfig {
    [key: string]: any;
    privacy: 'events' | 'update-only' | 'offline';
}
