#!/usr/bin/env python
"""
    Images stored as PhotoImage objects, for buttons and logos.
    Created Oct 2008
    Copyright (C) Damien Farrell

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
try:
     import tkinter as tk
except:
     import Tkinter as tk

def tableapp_logo():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhAAEAAcZxAAAAAAcABxQAKxUALRsFAyUAJCQAJycAJiQIACYKACgO'
            +'ACgUAEUAfCoVAEYAhEgBgkgBg0wAjE8AklAAk1EAlFQAm1UAnFsEn2QA1GcG'
            +'lmcA2WkB3mgB4WsB42oB5mwB44MJqIYKqYUD/Y0G14wcDogG+I0dDpEXQpYR'
            +'dY8K05gRdJsNuJ0Or6wVPpwOs5wOtKsVQ64ZPa0ZQbQfIqwbZ7UiIaweacAn'
            +'AL4qAL8qAL4rAMArAMIuAMIvAMQxAMQ1AMU4AMc4AMdIE89IALBEkNFJANBK'
            +'ANJLANFMALVIe9NMAMhXJslYJNNoANVpAN1tAN9uAN97AOB+AOOFAN+RAOCS'
            +'AOqYAOqZAOqaAOuaAOubAOyeAOyfAOygAOSlAPKlAPKmAOOuAPOqAO+tAO+u'
            +'APCyAOe1APCzAO62AO63APK9APW9APK+APO+APT0APT2AP//AP//////////'
            +'/////////////////////////////////////////////////yH5BAEKAH8A'
            +'LAAAAAAAAQABAAf+gAsNg4SFhoeIiYqLiAqOj5CRkpOUlZaVCQiam5ydnp+g'
            +'oaKgBAGmp6ipqqusra6tTlCys7S1tre4ubq3RUe+v8DBwsPExcbDSkE5O8zN'
            +'zs/Q0dLT1NEmBgfZ2tvc3d7f4OHeBU1P5ufo6err7O3u60NG8vP09fb3+Pn6'
            +'90hAODoAAwocSLCgwYMIC5LAJq6hw4fiyL2bSLHixHj7MmrcuK/fv4QgQ4pM'
            +'uBCiyZMPJVpcyZIiRo4wY2b0OLKmTZElUercuU1ly59Az72USbSoPJo3kyoV'
            +'mJOn05M+g0pdOdSoVY5Il2q12fSp14ZRp4p9V/WqWX1Zt6oF2fWr23H+5cbK'
            +'dVf2rN16adfqVcjwrV9uYecKNlf3ruG8exMDbPvXb+DBcwsbtotY8V7Gjd0+'
            +'hjxW8mSzlS2vxZzZ62bOUz1/thpa9FbSpZ2eRh1U9eqirV0vhR1752zaP23f'
            +'lplbd1LevVH+Bs5S+HCYxY1z7ZvcdFzmnZ8f9if9MvXqsq9jT639bvTuOL+D'
            +'9y1+fO3ylLmjV4t8vcPl7i/CP3t+Pkn19kHVXn4tObcfWvL5txuAAUKEH4Ht'
            +'GHggPv0paFB9DYLzIITwTMhaghbehGGGcHEIlIQe4gViiDWNSCJgA5roUoq4'
            +'rchiei8qF6OMZNFIVIU3BuRijtlsyCNhPhL+Z2OQ/xFpkpFHopgkkEwOSSSU'
            +'PErpI5VBWpkjljJqSSOXN3r5IpgmipkimSyaSSKaHKrpIZshupkhnBDKOSGd'
            +'FtrZIJ4E6nkgnwr6GSCg+Qm6H6H+GWofou4pCh+j8zm6HqTjSVoepehZCh6m'
            +'2GmqHafdeVodqMyJ+hyp0pmaHKrAqTocq8a52hustMl6G6262Robrqjpuhqv'
            +'rvlaGrCcCfsZsaIZmxmykCk7GbOWOdsYtINJu91HTOLoZEo7HsmOtuYt2e2F'
            +'DH7bDbaCkRsft+c2qS5Y4Yqrjrv8mRvvQNb+xW5kScZErWL9OlavvejgC5q+'
            +'+wqZ7rza/CuXwlf+DZxYwW9JnF3AWDHcsA4Ya3YwwkhyvJHF3kEc0cgkU/wh'
            +'vB8TFPJXGovlslEo6zWzdSTrZ7JGOY/2sMo1k/fzTB43vPNTRUt1c40wx8zU'
            +'0BA3/d7RHSW979Lh9dwj1ghGLfViVM9r9Ylghz02XyqHc3ZwaecTNH1lq/t2'
            +'gXFTqHW8XPN0d3N587P3uX37FkYaaCSu+OKMN+7445BHzngaUUhh+eWYZ675'
            +'5px37vnmUwgxQw2kl2766ainrvrqrKd+ggMPxC777LTXbvvtuOdeOwQMuAHH'
            +'78AHL/zwxBdv/PHEj1HG8sw37/zz0Ecv/fTQr7EEDDJkr/323Hfv/ff+4Ifv'
            +'PQocbGD++einr/767Lfv/voY+I78/PTXj7zy1Oev//7UW4+9+AAMoADFR773'
            +'GfCACDRg/OzHwAbWD3/8i6AE8+e/AVrwggIsYAI3yMEDLtCBIAxh8CA4wRKa'
            +'cHkVxKAKV7g9DXbwhTA83wdFSMMGkvCEOORfClnIwwu6MIZA3OAMa0jE+d0w'
            +'h0ic3g57yEQA/jCIUHzfEItIxeQl8Yr9u14Tt0jA8kXxi+6bYhXH+LsjYvGM'
            +'ZVgiF9eovSeC8Y3mEyMZq2hGNF5RjWxcoxvhCEY5zrGIdbQjEvGYxy3ukY9R'
            +'9OMfaxhIQeKQkIVk4iERGURFLlKEjXSkCSH+GUkeTpKSMbTkJUGYSU1OkJOd'
            +'XOEnQflCUY7ShqY8IypTicFVspKDrnyl/UoZSx1qkZaG9OItEyk/XRKRl73U'
            +'3yyBOUBbDhOBuTSmEZOZxGUyM4DOfKYCiylNTFJzkL+8pieFqc1QcrObpPxm'
            +'Dq0pzvBls5ztiyY6i4dMdUaPne383jvhCb9zzpOB9bTn8/CZz+7tk5/pk+c/'
            +'hRdQgTaPoAVtITkRKkR/LpR+DXUoCsMZUQselKJxtOhF76fRU3K0oxmcKEg9'
            +'KNKRGi+jGoUoSj8KUoW6FKYOlWlHaUpRm44UpwLVaUR5ilCfXhSo9hRqQYnK'
            +'T6MuFKnqVGo+mQr+T6f+E6rflGo7qVpOq84Tq9TUqji5qk2vohOsyRTrNcn6'
            +'TLN2E629VCsz2TpMt0oTrrGUKzDpeku7GhOvptQrLfnKSr/qErCaFGwqCQtK'
            +'w74SsY5UbCcZS0nHjhKygpRsJCmLSMteErN21GwhOctHzy4StGgUbR5JC0fT'
            +'/hG1sjwpSp2o0pVKsaUutWJJI6haNrL2ja6dI2yx2Fs91ta28cRtbhm6W97K'
            +'drbuPC5y+7ncBzbXl/+DLjalO92EKre6Zbzu/orLxd/28bvgHe4dn6vd8XG3'
            +'uzJEb3XVW032tpd75v1icMlIX3Bm977gyy8xwTtN8VLQvgDOnoChuN/+MfZ3'
            +'nQhO8IIrKd/lPviREQbwhIHYYDoa+MD/TbBB3wvfDXSYihc+IXmDWeLbEpik'
            +'H1Zihu+7YXO++Hgp3uSM21tjGJ4YkDGWcYhFLNEWh7HCuc1xCVfcxB63Esk3'
            +'DbL0mCxJEsP3x8eU8j13rF0ndxDLjNRy9bgMXS/jEso/FfNAyTxbMwvxDTc2'
            +'HhnOQOc62/nOeM6znvfMZzynkQktiIGgB03oQhv60IhOtKIPrQIPdODRkI60'
            +'pCdN6Upb+tKT/oAGzNAGNXj606AOtahHTepSmzrUbNhCF1bN6la7+tWwjrWs'
            +'Z/1qLoghCSNIga53zete+/rXwA62sH+dgQH+GPvYyE62spfN7GY7m9kC8MIY'
            +'pk3talv72tjOtra3je0saOHb4A63uMdN7nKb+9zkBgMRRFCCdrv73fCOt7zn'
            +'Te96y/sCAMi3vvfN7377+98ADzjApc3tghv84Nz2NroXzvCGo1vd7La3xCdO'
            +'cXvjW+AYz7jGM05whHv84wVXuMNHTvKFQ7ziKE85xS++8Za7XOMdB7nMZz5t'
            +'kZf85jj/9slVzvOev5vlLw+60Pcdc5obHeE2z7nSHb5znzs95UAfutRdXvSj'
            +'W33bSV+61s/d9Kd7XeJRn7rYMV71q5vd2lnfutrF3fWvu/3eY487x89O926v'
            +'/e7pXvfb9w53ufv+/d9lr7vZ0453tbed73sP+9//HnjBW53whdf64RHvdsUv'
            +'Xu6Nd7zRIR95pU+e8l63/OXHnnnNz5zzncf550HvdNGPfuqlNz3IUZ/6kq+e'
            +'9T13/euHHnvZe5z2tR/57XGvct3vPui99/3BgR/8hg+f+Cg3/vGprvzBN9/w'
            +'eof+16U//Y0nv/oJv/7Wn6/9iXO/+3MH/9GZL36uZ7/8rUd/3L+v/myzv/3l'
            +'Jj/8631++Qec/vV3bfeHf+Omf/s3b/3nf4AXgDQ3gAQYbgZ4gPGWgArYbwDI'
            +'gNTmgA+oc+8ngVBXgVJ3gRg4Bhq4gRHoge5GgSCobyKIgSX4gCeIgiX+oIIr'
            +'CAAtyIAvSIAxiII0uII3GIA5iH876IE9CII/WH9B2H5DKIFFWIFHqH5JKH5L'
            +'eIBNqIBPCH5ReH1TuH9V6H9XWH1Z2HxbCH9dKH9fqHxhGHxjWH5liH5n6Htp'
            +'WHtrqH1t2H1vKHtxmHpzCH11OH13aHp52Hl7SHx9eHx/qHmBGHmDiHuFuHuH'
            +'6HiJWHiLyHqN+HqPKHiRiHeTCHqVOHqXWHeZeHebSHmdeHmfSHehuHajiHil'
            +'uHineHapiH0RJ4MV14qMN4Kzt4E3t4p8Z4t+94rWp4skx4uJV4PIh4sfF4vj'
            +'14G0CHbG+HLAeHXKKHnM2Iz894zUh4xIJ4z+w1iN1oiA2Nhy0fh43Ch83viN'
            +'ExiO3qeN21iOzneO6Phz6ghz7Lh87viOsxiP4DiPZFePBjeNS0eMb+eLmOeP'
            +'IXePDCeQlceP/WiQWIeQJgeP+jiDDClw47h+EPlwEqmPBDl/DvmQGWluCrl9'
            +'Ffl/H6ltAOl5GxmPHUl6J2l/ISmSK4mOLSl2F7l5MZl/M/mNNQl7L2l3OVmA'
            +'O2mNPRmCPymAQSmU+TiR8FaUvHeUaJeUbDeUzeiUQneTDSiVEEiVtGiVxwiV'
            +'GaiV4DaSoVeSAweWYSmWWkCWT+eV0IiWNaeWa8mVMuiW2YiWKZlzX0CXPGiW'
            +'/0YFVhCYgjmYhFn+mIZ5mIiZmIZ5Az3QmI75mJAZmZI5mZRZmZLpAzTwAiyw'
            +'mZzZmZ75maAZmqI5mqAZAhVgAaiZmqq5mqzZmq75mrDZmhRQBVdQm7Z5m7iZ'
            +'m7q5m7zZm7mJBTzwA8I5nMRZnMZ5nMiZnMp5nEFgAyvgAtAZndI5ndRZndZ5'
            +'ndhZnSAgARPQnd75neAZnuI5nuRZnuIZAbTpm+q5nuzZm8C5nPAZn/IJn835'
            +'nNl5n/iZn9m5nebZn/75n/2Jnu05oAS6nu85nwiaoPFZn/rZoA6an/wJoBI6'
            +'of4poAV6oRhqmweqoBzaocPJoA8aoiIqnRFKoSZ6ot5poRm6ogO6oR7++qII'
            +'CqIjOqMOWqIoeqMSqqIsuqO+6aIw+qPLKaM0OqT3aaM4eqTmqaM8uqS/GZxA'
            +'+qTKKaREOqXayZ1IeqXlqaRMuqVX4KNQ+qXCKaVUOqbQaaRYeqbdqaVcuqRe'
            +'CqZQKqZkSqVmiqZYqqZruqNt6qZACqdxSqRzSqdIaqd3uqJ5qqcwyqd9SqN/'
            +'Cqg4KqiDiqGFaqgeiqiJOqKLyqgo6qiPWqCRKqkcSqmVGqKXiqkmqqmb2qJO'
            +'6qlPCqqhWqNWSqpXaqqnyp6dqqox6pytKqevCqtHKquzqp61aqvyyaq5CqG7'
            +'yqs36qu/6p6pKqwvSqzFWqTHiqwnqqzLupv+weqsQYqr0aqo00qtFGqt19qk'
            +'2nqo3Nqtlvqt4Jqj6TmuF5qt5Yqc0Iqu1jmq65qk7equBAqv8Wqc80qv1Gmv'
            +'90qe4qqvtcmv/Uqc/wqwJKquAxug+WqwtNqsCTufC8uwZeqwD5ulESuxwEqx'
            +'Fbug54qx+imwGwueBWuwCBuyF4uxJnuyKdqxHsusIZugLcuwLwuzE5Cy+rqy'
            +'FXuzAJuzMMuz7uqzCQu09Cq0J0u042q0/Yq06Kq0G8u01+q08Qq13Sq1D0u1'
            +'y2q15Yq10aq1A8u1v+q12gq2xSq290q2s2q2zoq2uaq268q2p+q2wgq3rSq3'
            +'4Eq3m2q3toq3oar+t9TKt4/qt6oKuJUquMhKuINquJ6KuImquLzKuHfquJIK'
            +'uX0qubBKuWtquYaKuXGquaTKuVzquXoKumQquphKultqum6KumOquozKukzq'
            +'umAKu7qqswBKu2wKsjUbpSNLsvgpu4DKuzxqu1+Ku1NKvHRqvHjqu78rr8Er'
            +'vPupsbr7nc7Losj7ptNLvdfJvGiavYQKvdHrr93rvVV6vRUqszOLreRbvgp7'
            +'vug7neB7puKbodu7qvI7v9FZv3XKvu1LrvC7rfbJv99rveq7swAcwLeZv3u6'
            +'vwbsv7G6wAx8sO87wD+gvH6KwOp7v5B6wQOswUMqwYFKwRXswD8qwt5omsD4'
            +'WsE9CsLwq8IzSsK9asIMjMLmWsAGnL4sTLA2HMA4/KwQzL803Kg/3L5BPKlD'
            +'PL9FnKxHPLNJ3KEynK497MMuTLMYnJxTLKJNnKlP7LFR/KlLjL5dXK1fLLFh'
            +'rKBbLKocfL0REAgAOw==')
     return img

def add_row():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAACFfHSZlIixtJzN1Ljd6MTl9Mzp+NEJ3uzyBNj2C'
            +'N0GHOkKIO0iPQEqSQkuTQ0yVRE2WRVGbSFijT12gVV6rVGOlWmOxWXy+dn7B'
            +'eVKEw1WGxlaHx12KxV+MxlmKyFuKyV6Oy1+Py2OSzmSTzmiW0WqX0W6Z02+b'
            +'1HKe1nSg13Wh13qj2nqk2X2l3H6o3YDBeoTDfoCp3YKq34Ss4Ieu4Yiv4oyx'
            +'44yy5I+05ZC15pO355S355a66Zi66Zq865u9652+656/7InGgorGhI7Jh5PL'
            +'i5fMkpjOkJ3QlKHTmKXVnKTToLDYrLrdtr3fuZ/A7aHB7qLB76PC76bD6anE'
            +'6KrG6azG6azH6K3H6azH6q3H6q7J6a7J6rDI6LDJ6bDJ6rLL6rPM6rXM6LrQ'
            +'67vQ677S67/T69ji8Nvk8dvl8d7n8t7n8+Lq9Obt9urw9+vx9+3y+O7z+e/z'
            +'+fD0+vH2+vL2+vT3+////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAMAAHkALAAAAAAQABAAAAjPAPMIHEiwYJ4p'
            +'UqAE+dFjhw4cNmjIcMFCYJQ7GDNqxKhCoJA7S5QkQWKkyJAYMDDcQSEQyB08'
            +'MGPKvGNCoI87VHLq3HmHhEAeOPFUiYklJhwRAnPYsXJFSxYuX7B88TJmzQeB'
            +'N+p0wQMmAsyiMNVsEFiDThgxEBqIuVBhggQHDA4QGDBjDp4HFigoMPDESRMm'
            +'R4hkEPBiDpkyCxKUcQtX7gABAVrIMYPnTAGYW2Ki8SBwRZw3btqwSYOmtOkO'
            +'AlOcKDEiBAgOGmLLRmCwdsGAADs=')
     return img

def add_col():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAADdrGT5wIkx7MUR3a09/e1OMKFePLV+JSWCJSWaO'
            +'T3GXX3y+dlKEw1WGxlaHx1mKyFuKyV6Oy1+Py2OSzmSTzmiW0WqX0W6Z02+b'
            +'1HKe1nSg13Wh13qj2nqk2X2l3H6o3YGrYYe5YIe6YIu6Yo26ZIy8ZY+8Z4+7'
            +'aoDBeoTDfpGvnY6uooCp3YKq34Ss4Ieu4Yiv4oyx44yy5I+05ZC15pO355S3'
            +'55a66Zi66Zq865u9652+656/7InGgo7Jh5PLi5jOkJ3QlKHTmKXVnLHTkLLS'
            +'lbHWkrTUlbbUnJ/A7aHB7qLB76PC76bD6anE6KrG6azH6K3H6azH6q7J6a7J'
            +'6rDI6LDJ6bDJ6rLL6rPM6rXM6LfO6rrQ67vQ673R677S67/T69Dmutji8Nvk'
            +'8dvl8d7n8t7n8+Lq9Obt9urw9+vx9+3y+O7z+e/z+fD0+vH2+vL2+vT3+///'
            +'/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAMAAHQALAAAAAAQABAAAAjTAOkIHEiw4EAm'
            +'SnjowGGjxowYL1p86CBwiZyLGDNe3CCwhxwiQ4QEAfLDh4oUDORkELhDzpyX'
            +'MGPKuSAwhxwnOHPqlFNB4I2bB57AjAJzzQSBNOJAQTFFCpUrUa5Y2WIGgkAZ'
            +'cKocwDIUZhkHAmG8yYJCi1kuUVgsUICggEAXbrgc8AJzRQgkYlAcCEAHhJsu'
            +'KLwI/pKgyJE5Jk7w9dAGzIEwMAckgWmELwc2atKgOUNmjAASI+aIUExHAwYL'
            +'FCREeNCAgIESRkoY4GtwYIDbt+kEBAA7')
     return img

def del_row():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAAEJ3u3y+dlKEw1aHx12KxVmKyFuKyV6Oy1+Py2OS'
            +'zmSTzmiW0WqX0W6Z02+b1HKe1nSg13Wh13qj2nqk2X2l3H6o3eoRHOwaI+4m'
            +'Lu4oMO8sM/AxN/E1OvE2O+RZU/RFSPVJTPZOUPdTVfdUVvhYWedhWPphYPpj'
            +'Yvxvbf54dIDBeoTDfoCp3YKq34Ss4Ieu4Yiv4oyx44yy5I+05ZC15pO355S3'
            +'55a66Zi66Zq865u9652+656/7InGgo7Jh5PLi5jOkJ3QlKHTmKXVnJ/A7aHB'
            +'7qLB76PC76bD6anE6KrG6azG6azH6K3H6azH6q3H6q7I6K7J6a7J6rDI6LDJ'
            +'6bDJ6rXM6LXN6r7S67/T6/mZk/qinPutpvu5sfzDutji8Nvk8dvl8d7n8t7n'
            +'8/zLwf3OxOLq9Obt9urw9+vx9+3y+O7z+fH2+vL2+vT3+////wAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAMAAHEALAAAAAAQABAAAAjMAOMIHEiwYBwk'
            +'R4rw0IHDRo0ZMV60qDBBoJE3GDNqxBhBYI83RIYICQLkhw8WKwS8eSBwxxs4'
            +'MGPKfNNAYI43SXLq3PlmgcAbOOEoidkkppoEAmm4WcLkiRMpVZpUoXJljAGB'
            +'MtpMgWOFaEwxJwTCUKEiBQoSIDpkwEAlCpgRIeK4UGGmzBcvXbhsuQCnhAgT'
            +'HzhYMItWLYYLF7BgAeNhQxwKbLLA0RITSkwwGgRKWJMGzRkyYcCIHl1AIAQH'
            +'DBQgOEBggOvXAQzKLhgQADs=')
     return img

def del_col():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAAHy+dlKEw1WGxlaHx1mKyFuKyV6Oy1+Py2OSzmST'
            +'zmiW0WqX0W6Z02+b1HKe1nSg13Wh13qj2nqk2X2l3H6o3bpDBLhFA7lEA7lF'
            +'A7xCBLxDBbxNBbxWHb1XHrhWIr5bKIRnaYttbsRXHd1kAcdlJ8prL9J2PeFo'
            +'A+52AOp5Be9/GPh2AP93Ef9/GOZ3IYDBeoTDfv+GIeuKQP+STfSdY/WocreT'
            +'ib+Xi4Cp3YKq34Ss4Ieu4Yiv4oyx44yy5I+05ZC15pO355S355a66Zi66Zq8'
            +'65u9652+656/7InGgo7Jh5PLi5jOkJ3QlKHTmKXVnJ/A7aHB7qLB76PC76bD'
            +'6anE6KrG6azH6K3H6azH6q7J6a7J6rDI6LDJ6bDJ6rLL6rPM6rXM6LfO6rrQ'
            +'67vQ673R677S67/T6/a1jfe1jf7Nrv7WuNji8Nvk8dvl8d7n8t7n8+Lq9Obt'
            +'9urw9+vx9+3y+O7z+e/z+fD0+vH2+vL2+vT3+////wAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAMAAH4ALAAAAAAQABAAAAjXAP0IHEiw4MAp'
            +'UZAYISIkyI8eO3JQkCBQCp+LGDNehCAwCR8oT5w0YbJESQwYAfg4EHiET5+X'
            +'MGPyYSCwCJ8qOHPq5KNA4JCbLazAxAKzDgKBQPZc0aAlyxYvWLx0EQOngEAf'
            +'eri0+DIU5psBAnnkAaMhjNkxWG6A2OAhhEAdeMa0KAMTxwk1bGyYsOCnAh4y'
            +'GsoINvMhDY0WMmZg8DPhzpkWaGBuWANzhQY/EezQmSMnjps2HWq4YJECRQY/'
            +'DxosSHDAAAEBIkq8UEGCwwWDBEdk0JDhdkAAOw==')
     return img

def delete():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZvALdKK7hKKrpLLrhOLrxLML5PNrxQMr1RNb5TOMFNM9BP'
            +'PsRQNMBTOsxSPMZVQsdXRctZScxbTNtWS9FeU9ddUeZWTOZYTOZZTulZTelb'
            +'T+ZWUOZaUupcUOxfVOddWc9hU9ZgVNdiXNljXdpjX+5mUuBlXOljW+pmXO5q'
            +'XvBkVvNzXdpkYdxkY9tpZN5qZ91qaN9qauNrYeNuY+BpauJwZvJ3Y/N5Y+R4'
            +'ceJ7del7cOh6del/ePaCaPaEbO6KdeqDfe6Efe+GfvCFcPiGcPCMd/iMdvCD'
            +'e/GOevCRf/eRfveTfvmSfvqTf/iUf+6MgfSOge2Tju6Sj/qah/qdi/GclvGd'
            +'lvqjkfSgnvSinvWjn/upnPqrnfOno/WmoferofarovWsofWvpfivpPKtqvS0'
            +'qvi2qPm5r/q6rvzHuvjDvvnLxPnTzPzUzf3b1P3c2P///wAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAHAA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB6GAcIKDhIWG'
            +'cC8sKyKHgzNQaWtqZDQThzNjbmZWU1toORGFM1xtUkhHTExFZTIPhD9sU0o+'
            +'PbU9NmIKgy5hW0QdwME1TzsMgi1mTEJvzM0YKFUFgiNfQzzNzidU0nAhTkoq'
            +'GOLjF0Y4AoMSXykkFeMWG1kLhB8xYMAYFxUVXSABhRBKdDFywgOQLBQAHHLQ'
            +'QEeUKDcSKGwEB8EBAQMoahwUCAA7')
     return img

def new_proj():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAAEJ3u3y+dlKEw1SGxFWGxlaHx12KxVyKxl+MxlmK'
            +'yFuKyV+NyF6Oy1+Py2OSzmSTzmiW0WqX0W6Z02+b1HKe1nSg13Wh13qj2nqk'
            +'2X2l3H6o3YDBeoTDfoCp3YKq34Ss4Ieu4Yiv4oyx44yy5I+05ZC15pO355S3'
            +'55a66Zi66Zq865u9652+656/7InGgo7Jh5PLi5jOkJ3QlKHTmKXVnJ/A7aHB'
            +'7qLB76PC76bD6anE6KrG6azG6azH6K3H6azH6q3H6q7I6K7J6a7J6rDI6LDJ'
            +'6bDJ6rLL6rPM6rXM6LXN6rfO6rrP6rrQ67vQ673R677S67/T69ji8Nvk8dvl'
            +'8d7n8t7n8+Lq9Obt9urw9+vx9+3y+O7z+e/z+fD0+vH2+vL2+vL2+/T3+///'
            +'/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAGUALAAAAAAQABAAAAjEAMsIHEiw4EAc'
            +'NlqsSHHCBAkRIDxowCDwxpiLGDNetCDQxZgaNGbIiAHjRQcOAsZQEMhiDJmX'
            +'MGOOkSBQxRgdOHPqHANBIIqbZHbA9AFziwOBJcLw6AHkxxAjPowUUWJFgcAR'
            +'YIiQOTIUZpUCAkN8QZKkbBImPnwUETKFgMAPXpiQeQKziZiXUxgI3ODFyZO/'
            +'T6AsGbxkCgKBGbpEISMFZhCYUxIIvMBFSxYsV6hM2cz5gMAKEyI8aLDAwIDT'
            +'qAMYXE0wIAA7')
     return img

def open_proj():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAABV5ABt5AB57AyF9ACV/ACZ+ECR8FUJ3uy2DAS2D'
            +'CTWHCTCHFzyLEESPFkaQGUqRHFKXIleYKFubKV6fOlygPGKdMGOfMWWfMWih'
            +'NGujN2mjOW6jOG+lPW6kPl+hQ2KjRmalSGilRnSrT3yvVXy+dkmCpVKHpVOG'
            +'vFKEw1WGxlaHx1mKyFuKyV6Oy1+Py2OSzmSTzmiW0WqX0W6Z02+b1HKe1nSg'
            +'13Wh13qj2nqk2X2l3H6o3YGzWoCzYYK1Z4W2ZoW2aom4a466b5C8dIDBeoTD'
            +'foCp3YKq34Ss4Ieu4Yiv4oyx44yy5I+05ZC15pO355S355a66Zi66Zq865u9'
            +'652+656/7InGgo7Jh5bBgJfCgpPLi5jCg57FiJjOkJ3QlKHGiqHHiqXIjajL'
            +'kKnKkKrLka3NlKHTmKXVnLDOlp/A7aHB7qLB76PC76bD6anE6KrG6azG6azH'
            +'6K3H6azH6q7J6a7J6rLK4bDJ6bDJ6rLL6rPM6rfO6rrQ67vQ677S67/T69bi'
            +'6t7n8uLq9Obt9urw9+vx9+3y+O7z+e/z+fD0+vH2+vL2+vT3+////wAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAJAALAAAAAAQABAAAAjcACEJHEiw4MA2'
            +'a6xQkQLlSZMlSY7syCGQjaOLGDNevCHwiqM0aMB84ZIFi5EiJRzVEFjF0aOX'
            +'MGM6miFwiqM3OHPqdBRDYJSbj+DAnAPz0AuBThrFkVOHjp08czxgwDOIhUAm'
            +'jO480jN0Qw8JglQIVLJoDx8+HThksEDCzIgHKAQiUdTn0R8Nas6YIUNEjIgF'
            +'Anko8vPnz4UzQ4QA8fGjS4UCkHQkAvQo0IQyY8J4CbIlhAGBOBAZKkQoAgQH'
            +'DShoAcHghEAbNGTAcNFiRYoUCj4cMIHAYEECAwgGBAA7')
     return img

def save_proj():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAACBarS5fpjppqj5qqzNoukRtq0RwsFd+u1F/w1N/'
            +'wXy+dl2Ev1SBxFWDxliEw1uGx1uKyV2IyF6Oy1+Py2GKx2CJyWGLyWKLyGWN'
            +'ymWNzGiOzWyLzWiL026K122L2myN3GOSzmSTzmmQzW6TzGiW0WqX0W6X1G6Z'
            +'02+b1HGY0HOZ0XOa1HKe1nWa0Hee2Xmc1Xue1Hie2Hif2Hmf23uc3XCP4XSg'
            +'13Wh13mg2Xqg2Xqj2nuh3Hqk2Xyj232j3n2l3H6l3X6o3YS/UYS/VIDBeoTD'
            +'fpjJb5nJcYKk1oCm3YWi3YCp3YKq34Wo3YGn4YGn4oSs4Ieu4Yiv4oyv5Iyx'
            +'44yy5I+05ZC15pK15pO355S355e26pa66Zq275m46pi66Zq865u9652+656/'
            +'7KG/6qG/74nGgo7Jh5PLi5jOkJ3QlKHTmKXVnJ/A7Z7A76HB7qLB76PC76bD'
            +'6anE6KrG6azG6azH6K3H6azH6q7J6rPH47DJ6rLL6rPM6rfO6rrO77DN87rQ'
            +'67vQ677S67/T68fuh8fujNf0otf2ot7n8///3eLq9Obt9uXx7ebx7ebw7+bx'
            +'7+n05Ojz6urz8+rw9+vx9+318+3y+O7z+e/z+f//4PD0+vH2+vL2+vT3+/H4'
            +'//f7//r7/fr8/fv8/fv8/vz9/v39/v///wAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAKkALAAAAAAQABAAAAjzAFPFcTMmTBct'
            +'WKxMicIEyI5UqeB8mkix4sQbEMl8asNmjZo0aM4YKbLgUwqIYj6hWsmy5ScT'
            +'EMF8mkOzps1PIiBumYmKDss7LC1RgHjFUx07efCciKEiyYYRLlZgSFWlkx5U'
            +'fFBpCIRqT8syFqRw6uOnLIQ3qEisDAWKSoUmmv6gGoRKgplRpU6ZEkXKiQIh'
            +'mgQNGpzhSxAlPnTkmCGDQY9MhFAVQnUhC5QnP3jQeMECAQ5MlRoxUtSAC6VH'
            +'kSA5ugTjQAsUJUJMiJDAy6QhR5AQkVRjAMTfqRwAWmQIUaJDm5YQAA6xwIMO'
            +'NkB88MDBgICAADs=')
     return img

def prefs():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAAElJSU5OTlFRUVJSUlNTU1hYWFpaWltbW1xcXGFh'
            +'YWJiYmRkZGdnZ2lpaWpqamtra21tbW5ubm9vb3FxcXZ2dnd3d3l5eXp6en5+'
            +'foCAgIGBgYKCgoODg4SEhIWFhYeHh4mJiYuLi4yMjI+Pj5OTk5SUlJWVlZmZ'
            +'mZqampycnJ6enqCgoKGhoaOjo6SkpKWlpaampqenp6ioqKqqqqurq6ysrK2t'
            +'rbCwsLGxsbKysrW1tba2tre3t7m5ubq6ury8vL29vb6+vr+/v8DAwMHBwcLC'
            +'wsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR'
            +'0dLS0tTU1NXV1dbW1tjY2NnZ2dvb29zc3N3d3d7e3uLi4uTk5OXl5efn5+np'
            +'6e3t7QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAGYALAAAAAAQABAAAAjUAM0IHGhmCZIh'
            +'BBMOXCImjA2FA6U4MWPkixcdZmzIcEGwSxkuRoRkuYLDxpMxPUQIdIKky5Ut'
            +'XEZusfKEyQWCSa5AafJDRQsjSor0GMgECREtUYBwEEjiiJEoI0B0QEImSxMp'
            +'MAjaQPJDiRcIQ8BYURIlB8EZRnoQsaLABQkWU5RAWcG0CBAfDAwUGJikSJIl'
            +'NGQUEbKDhgOCMbAkeVKlyRIoSYI8kdBA4AsgX2J0+IDESAQJMaxoILhhAgMz'
            +'HZ4sWWDGgACIAjcE0YEANsEIBgZADAgAOw==')
    return img

def plot():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAAC5fpTBiqTBiqjJkrDNmrjRosTVosjZrtTdrtjxy'
            +'vz10wj51wz52xD92xT93xkZwu1prrUJ3xkB4x0F5yUF6ykJ6y0J7zEN8zEN8'
            +'zUR9zkV+0EV/0XCfvY1Sfa5FZe0iK+4mLu4nL+8oMO8rMu8tNPAuNfAxN/Ay'
            +'OPEzOfE2PPE3PPI4PfI5Puc3Qeg4QfI7QPA9Q/I8QfM9QvM/Q8xNYvRCRvRD'
            +'R/RFSPVKTfZNT/dSVPhXWPhYWflcXPldXflhYPpjYvtmZftnZftraY9kk6he'
            +'goyhwJOs0Zyx0P6WlPyZl/61sgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAE0ALAAAAAAQABAAAAhzAJsIHEiwoMGD'
            +'AnEgNHhjSYuFBGewgEhwBUQNA1UMJDIkCMEMSTpEeNEkwYECQpj8IEjBQRMX'
            +'HxAYODIAiA8eO3QYkSAwhQmBBAQEIFikRowVKEosrDDwhBIRBjdgoECQRAgQ'
            +'Bi8gaUBR4AQGCrqKHWswIAA7')
    return img

def plot_clear():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPedAGVCPXZsJXsueXwzfH04f2pBbWhTe6pJB6lMCblFA7tC'
            +'BLxCBLxCBbxDBbtNBa5NG7hVF61PIL9dIt1kAeFoA+52AOp5Bfh2AO9/GP93'
            +'Ef9/GMZjJ8tsLs1yO+Z3IfM9QfVHSvZRU/5ZVvhbW/5eW/5hXfpkY/5mYv5p'
            +'Zfxsav5va/5xbf1xbv1zcP52cv54dP55df5+eU2WRVWhTVyoUmGwV2e2XGy8'
            +'YP+GIbGPXuuKQP+STfSdY/6BfPWocn4/gxEuwBIxxBI3xhM6xhVDyRZMzRhV'
            +'zxhXzxpg0Rpi0R5p1h5r1ip02Cx02Dl72Tt92Tp824BEh5J6h0GA2kSD20WE'
            +'30eF30qG3E2J3VOM3lWN31aP31mP31KN4VOO4VyS4F2T4FyS4l6V4mCV4WOX'
            +'4WWY4mWZ5Geb5mqc42yc42ud5m6e5G6f5G6g6HOi5nSi5Xaj5Xil5nun53yo'
            +'532o53Cg6HSk6Hem6v6Fgf6Tkf6Vk/6Xlf6Ylv6bmfa1jfe1jf6gnv6kov6q'
            +'qP6vrP6zsP62s/63tP65tv67uP7Nrv7WuIGs6YOt6IWt6YWu6Ymx6oqy6o2z'
            +'6oyz65G27JK37JS37Zm77Zu87qDB7qLC76bF8KjG8KzI8v///wAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAJ4AIf8LSW1hZ2VNYWdpY2sKZ2FtbWE9'
            +'MC40NQAsAAAAABAAEAAACNUAPQkcSLCgwTt32Kg5I8YgwTqcNEns4nDgGU2U'
            +'IFmqUlFgGEyQHFWCUvDFCxcsUnSxtGhOpCYlER0qRKgKpThuHC0p2MIQnh6D'
            +'nEBig4ZOkoIpCsV4IagJozJj4By5YaMGjRkmBqEMtCTOFy9sDEhoACGHjBGC'
            +'UqAAlAROFixSOvxR5INDgBCBTpToYyTNFSoP/uzIgEMHAhCASIjYU4TMlCcL'
            +'EnWajEHBBz589OQhEoaLlwc8NFyoQOFAlB8EBggYIiQIkAIbPFiY4ABAR4EJ'
            +'FiQQGBAAOw==')
    return img

def plot_prefs():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAAFU9ETxyvz10wj51wz52xD92xT93xltujUJ3xkB4'
            +'x0F5yUF6ykJ6y0J7zEN8zEN8zUR9zkV+0EV/0XCfvYdfKJxpHYNlK6pkHL56'
            +'GrN3Lbl5LvAyOPEzOfE3PPI4PfI5PvA9Q/I8QfM9QvM/Q8dvIupeM8xNYvRC'
            +'RvRDR/RFSPVKTfZNT/dSVPhXWPhYWflcXPldXflhYPpjYvtmZftnZftraY9k'
            +'k6hegraDGZGKdJaTbaqJQ7yNQr2IScGCNNKIN9mMNtiMONiNONGVK+aBOOS3'
            +'JMGKTMmFQc2NRMWYSdCdRtqUQduVQ9yVQt+ZQNiaVMeXYs+daNilWNejY9W2'
            +'eta4c+e+d+TJVfXfW/XcXvXcX+3KbefLd+3QeO7Tee7Sfe7TfPffY/bdbPDT'
            +'efHUe/LWevfhWvfiW/jiXZOs0Zyx0NuxhdG3kPyZl/61sufAi/nHlPnJke/S'
            +'rPbTrvDStPnjsvzgxP32wv32xP33x//y4P/z5QAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAH0ALAAAAAAQABAAAAiZAPsIHEiwoMGD'
            +'AlUgNJjCDYiFBEd8gEjQA8QIA6ewWdLHRo0ZBCGsoaDjSh0+c47QeBOD4AID'
            +'fcDYgUPnjhQZMFy0YIEjgcAwecZwoRIFAcEbJ0KY+KJnCxozTwoyGNhFj5Yz'
            +'ZZwMlPBgwUAreMSkIdOEoAM1BQRWaYMlixcmBRUQENCHxx4oGZT8gHghjhwk'
            +'GCgGqOCjB8KAADs=')
    return img

def fit():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAADd1LTh1K/8CBv0NEfwOEvsWGvsXG/kZHPkhJPcrLvkq'
            +'LesqOfYzNvUyOPY2OeExRfU+QfRAQ/FIS+5KUPFNUPJPUu9XWe9YWvBRUzaE'
            +'KziCLD6SL0CKMUGIMkGJMkCPMUSfNUWdNkiaN0abOEiZOUmkOkukPEqiQD1O'
            +'uihjqyhkrChkrShlrillrilmrypmrypmsCposSpositosytptC1qti1rty5t'
            +'uS9uuzBvvTBxvmdgrxFh3hBi3zJywDJzwjNzwzR0xDR1xTR2xiRy3idz3gBX'
            +'4AJX4ANX4ABY4Aph4Bt24SBv4Cx/4DN/4KZbiDeB3zmC3zyG3z+J3j6I3zCB'
            +'4E+S3UuT4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAFgA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB4aAWIKDhIWC'
            +'Q4aJh1hWgxcXFomIU4IVlhiYhYhNVRARhBITV4M/WEs7DQ6DVVVRUpRYpVgL'
            +'D4NMRERYDE+CpQUHKEpYPDyDCgmCOlgEBElIz4UIgjlYAoQnJiWDBdOFJCLg'
            +'2oQ3gxzmgx8bhDVYAQABhhoZg+yKhjQx+DD7KjAq/ylU2FMUCAA7')
    return img

def refresh():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAACNhHyRjICVlIidmIyloJCprJixtJzJ0LDN2Ljd7Mjp+'
            +'NDyANT6DN0CGOUKIO0SLPUqLRUyNR0mRQU2WRU+ZR0+QSVGSS1SVTlGbSVOe'
            +'S1aXUFWhTVejTlqmUF6rVF+tVmKiW2OkXWWnXmW0W2e2XGi5Xmq7X2ioYGiq'
            +'YWusY2ytZW6wZmy8YG2+Ynazb3y9c36/dW7AY3/BeYG+eoHCd4PDeYLCeoPE'
            +'eYXHe4XEfofEgInDgIvDg4rEg4nGgovGg4vHhY3Hho7Gho7JhY/Jh4/JiJDK'
            +'iJLKiZHKipTLjJXMjZbNj5jOj5nPkJrPkpzPlJzQlJ7RlZ/Rlp/Sl6HSmKTU'
            +'m6fXngAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAFcA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB4mAV4KDhIWG'
            +'hBQSh4IjIx0ZEycgCoYlNUZQmUlDPRcGhCRDVUxOSkY9OTIRAoQwVE9BIg0L'
            +'CBUQAYQeO0o9DwuDAwCFG4kOv4vIhMQSxoUtLIOQQkUuCIQtODUeHRgpPEU+'
            +'Gtc3VlVTTps1OSEFhCMwUk9LST4zKhYEhhwrKA4MCQc+LWKWrCChQAA7')
    return img

def start():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhGAAYAKUAAP///+bm/+Xl/uPj/OHh++Df+d7d993d99vb9dvb9NnZ'
            +'8tnZ5tfW8NTU7tLS69DQ6dDP6c3N58vL5cnJ48fH4MTE3sLC3MDAzL/A2b2+'
            +'17u71Lm507e30LW1z7S0zrOzzLCwya6ux6ysxaqqw6iowaenwaWlv6OjvaOj'
            +'vKGguqChup6euJyctZqas5aWr5SUrY+PqI2NpoiIoYaGn4KDm4GBmoCAmTMz'
            +'ZgAAAP///////////////////////////yH+EUNyZWF0ZWQgd2l0aCBHSU1Q'
            +'ACH5BAEAAD8ALAMAAAAVABgAAAanwJ9wSCwaj8ikUogr3p7PJG7RHJpa1xsS'
            +'17lQh7arSWvkzrrfnw3bIhPNoXNVLXYzM+dZaK5m23EVMXgZfHRYbjgRLhUw'
            +'GIV9WUwNLooUj4ZjPzcNJg0sEZeQbQAAm50rEJdhhz+kNwadnY9rka2lBiGc'
            +'DYWrmUKuBSGwDHy0bUSuuAYlBnO9drY3ASEFzFXG0NEBHQHONt/Z2nykpEmu'
            +'S0gA6OvsSUEAOw==')
     return img

def end():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhGAAYAKUAAP///+bm/+Xl/uPj/OHh++Df+d7d993d99vb9dvb9NnZ'
            +'8tnZ5tfW8NTU7tLS69DQ6dDP6c3N58vL5cnJ48fH4MTE3sLC3MDAzL/A2b2+'
            +'17u71Lm507e30LW1z7S0zrOzzLCwya6ux6ysxaqqw6iowaenwaWlv6OjvaOj'
            +'vKGguqChup6euJyctZqas5aWr5SUrY+PqI2NpoiIoYaGn4KDm4GBmoCAmTMz'
            +'ZgAAAP///////////////////////////yH+EUNyZWF0ZWQgd2l0aCBHSU1Q'
            +'ACH5BAEAAD8ALAAAAAAVABgAAAaqwJ9wSCwaj8ikEKdM4hZM5G06HT4vnajx'
            +'1jJ1lwvsLHu8eU02a2cWGmuHXG/a2l5n3j9zd27NzDIxFW9xLXxWGDAVLhFa'
            +'emhHOBSLLg1RhIZEOBEsDSYNN3lnmEsQK52fAACXRjinJgY3qaF7Ra2eIbCy'
            +'eV2FmQyvIQWxAHCiVgYlBrjDRKs/OMgFIQHMzcZLAR3Uus28hjjbxFs25JjV'
            +'R6ncQ+JN7e7vREEAOw==')
     return img

def next():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAACBeHSRjISlpJS9wKjV4LzuANUKIO0WIP0mLREqM'
            +'RUmRQU+ZR1CRSlydVVahTV6hWVypU2KjWmKxWGi4XW2+YXy+dnHDZXTHaIDB'
            +'eoLCfYTDfofFgYnGgovHhY7Jh5DKiZPLi5XMjpjOkJrPk53QlJ/SlqHTmKPU'
            +'mqXVnKfWnqnXoKvYoq7apQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAC4ALAAAAAAQABAAAAheAF0IHEiwoMGD'
            +'CBMqXJiQAcOBCw4QxIDhQgUKEyI8YLBAgoMCAzG0YKEChQkSIkB44KChwQCB'
            +'F1akOFFiRIgPHTZksKBAgMCLGTdGNIAAQgKfDAcgZbj0odOnUA8GBAA7')
     return img

def prev():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAACBeHSRjISlpJS9wKjV4LzuANUKIO0mRQU+ZR1ah'
            +'TVypU2SqW2KxWGi4XXi9cnu+cXy+dnHDZXTHaH7AeIDBeoPBeoLCfYTDfobI'
            +'e4fJfIrMf4fFgYnGgovHhYvNgI7Jh5DKiZPLi5XMjpjOkJrPk53QlJ/SlqHT'
            +'mKPUmqXVnKfWnqvYogAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAMAAC0ALAAAAAAQABAAAAhdAFsIHEiwoMGD'
            +'CBMqXChwAsOGEh5O+KDBQYMFChIgOGCgAIGGG1isSHGixIgQHjhcoDBAoIQM'
            +'KlCYICECRAcMFSI8EDDQAQQLDDRy9DhAQACCGB8KTKC0qdOnDwMCADs=')
     return img

def search():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAIcAAAAAAHaczXufzXug0H+l05JaEJNbEZVdFJdfGJpiG51l'
            +'H51nIp5mIqNrKKVtK6hwMKpyMq93ObF5PLV9Qbd/RLyES7yNVcWXZMeZZsyi'
            +'dc6kdpKUnYqTooWp1oaq14qu2Yyw24+y3ZGox5O235y6352735a44Zq845u9'
            +'5J/A56LD6KbG66jI7KvL7q7J6K7O8K/P8bXP7LfQ7bTT9LvW87vX87jW9rnX'
            +'973V8L3X873Y877Z87vZ+b3b+r7b+r/c+tWuht21ieTBnejLq8Da9MHa9MLb'
            +'9MPc9MTc9MXd9cbd9cfe9cDe/MHe/Mjd88ne88je9cjf9cnf9crg9cvh9s3h'
            +'9czh9s7i9szi+M3i+dDi9dDj9tHl99Lk99Pl99bn99fn99Pm+Nbn+Nno+Nrp'
            +'+N3q+d7r+d/s+d7s+uHt+eLt+eLu+ePu+gAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAMAAG0ALAAAAAAQABAAAAiTANsIHEiwYEEe'
            +'NmbAaGFwoI8saNaoIYMjRcM2WNh8uUJlS5kYIwzeMPPFyhQoSahoAWFwRhor'
            +'UpYgMUJEjAeDL85EUXKkyI4cYQgYZAHGCk0dNYw8EWBQhYwxUHTQMNKlxIaG'
            +'JlxU8cLFCQkRQCY0/NCBwIAAHDIM0fDgIkEJF4RgUOB2oAMLQRDUHZhgwd6/'
            +'fwMCADs=')
     return img

def transpose():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAACxsJyxtKC1uKC1uKS9xKzFzLDd7MTl9Mzt/NT6EOEGH'
            +'OkKJO0OJPESLPUWMPkaNP0mRQkqSQkqTQ0yVRE6RSU+SSlCZR1GUTFOWTVCa'
            +'SFKcSlOdSlqdVFWgTFahTVijT1mlUFmmUF2qU1+sVV6gWGOlW2WnXWOxWGa1'
            +'W2a2XGm5Xmq6X2mrYWy8YG2/Ym6/YnGyaXK1aXm4cXi6cHu6cnu7dX68dX6+'
            +'dn6/d4HAd4DBeYLCe4XHe4LCfITAfYTDfoXDfoTEfYfEf4fIfInGgo3HhozK'
            +'go/Jh4/KiJLJiZLKi5PLi5TLjJbMjpfMjpjOkJnOkJvPk5vQkp3RlJ7RlqDR'
            +'l6DSlqHTlqHTmKLTmaLUmaTUm6TUnKbVnKfWnqnXoKrYoKvYoQAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAGIA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB4aAYoKDhIWG'
            +'h4iCLisoJ4liLkNXXl5QMx+HLkZhWV1bUVMzFoY8YVxZOjZQUVAshStTV1Mi'
            +'IBsbRUw+DIQppzcggxEPCwmEJ1dXMx2CEYgiSkxKGRNiEAuIMUxMSCYMJBwH'
            +'hxswSD5EQj49GAWHESU1PTo6NxUDiQkJBhf1j4ME9v0EASQUCAA7')
     return img

def melt():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAMZnACxsJy9wKi9xKzJ1LTN2LjV4LzV4MDZ5MDh8Mjp+ND6E'
            +'OEOGPUOKPEeMQUmLQ0iQQEmRQUmRQkuUQ0yRRUyTREyVRE6YRk+YR1OXTFCa'
            +'SFWgTFaiTVejTlikT1unUVuoUlypUl6qVV+sVWCuVmGvV2GjW2KkW2WnXmW0'
            +'WmurY2usZWyvZG+vaGu1YGu8YG66ZHK+Z3GyaHGxa3K0aXOzbXS2bHa2bXa3'
            +'bXi2cHi3cHu5dHq+dXy+d32/d2/BZHDCZXLEZnLFZn/AeYDBdoTFeYLCfITD'
            +'fYXDfofEf4nKforMf4fFgIjFgonGgozGg4vHhIrMgIzIhY/MhZDJiJDKiZLK'
            +'ipTLjJXMjZXMjpfOj5jOkJrPkpvPk57RlqHTmKLUmaTUnKbVnajXn6nXoKrX'
            +'oavYoq3apP//////////////////////////////////////////////////'
            +'/////////////////////////////////////////////////yH5BAEKAH8A'
            +'LAAAAAAQABAAAAeGgH+Cg4SFhoY+QIeDIy0vMFJKQYsaUV5gYmVmUJOFFzhc'
            +'XV9gY2NKioUSU1k3ISNDRC6DBQkKGDRTKxqCKCiEBDxDS0w6FYt/Ajs8RUs4'
            +'D8cAAgQOKksnz38aHosIR9YUGC01H4cGJUtRU1ZcXDUg5TJM6VlZM9vlCw0T'
            +'KykZx4QMsP07FAgAOw==')
     return img

def pivot():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAMZQACFfHiNiICRiICZlIidmIylpJSprJixtKC5vKTByKzJ0'
            +'LTR3LzZ5MDh8Mjp+NDyBNj6EOEGHOkmRQkuUQ06XRlGcSVOeS1mmUGOlXFyp'
            +'U12qU2eoYF+sVWCuVmKxWGW1W2e2XGi4XXO0ane2cHa3bnO5bW2+YnS7b3W7'
            +'cG7AY326dXi9cnDBZHm9c3DCZHDCZXy+cnu+dX2/dn7AeX/BdYDBeoLCfITD'
            +'fofFf4fFgIjFgoXHe4rFg4fIfIvHhI7HhYjKfonKfpHJiZTLjJbNjJbNj5vP'
            +'k57RlaDSl6LUmaXUnKbVnafWnqjXn6rXoavYof//////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'/////////////////////////////////////////////////yH+EUNyZWF0'
            +'ZWQgd2l0aCBHSU1QACH5BAEKAH8ALAAAAAAQABAAAAdtgH+Cg4SFhoeIhiYs'
            +'iYQgO0AujX8dNE1OQS+NGTBMTz0pkxpKTSGTfxdJSx+TFSJIRx6NEhRCRD8c'
            +'gwUHCQsNDxEYPEVGJIQDJysxMzY5PjhDKhaEASUoLTI1NzojGxOFAAIEBggK'
            +'DA4Qp+rrgQA7')
     return img

def aggregate():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAMZbACFfHiNiICZlIilpJSxtKC1sKS5vKTBwLDJ0LTN1LzV4'
            +'MDh7Mjl+Mz2CNz6DN0CFOUGHOkOJPEOKPESKPUWMPk6XRk+YR1GXSlSWTlOd'
            +'SlSfS1adTlqeU1qcVFaiTVejTlijT1qiUlmlUF2qU1+sVWGjW2KnWmOmXGWm'
            +'XWWrXGSzWma1W2e3XWi4XWm5XmmrY3OybHO5bXS7b3i5b3i2cHi3cHW7cHi9'
            +'cnm9c32+c3u5dHy6dXu+dX7AdX/AeH7AeYO/eoO/fIHCdoHDd4TDfYXDfofF'
            +'gYjFgonGgovHhY3HhY3Iho/Jh5DKiZHLipLKipLLi5PLi5bNjpbNj5jOkZzQ'
            +'lJ7RlqDSl6LUmaTUm6bVnf//////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'/////////////////////////////////////////////////yH5BAEKAH8A'
            +'LAAAAAAQABAAAAd+gH+Cg4SFhoeFFBcbIR6Igw9GSU1BII9/DUVHS000loIs'
            +'hQwNEyhKTY6CKi2HEydNOykiIzlDrIYSOlFTVFZYWraGDzRMUVRUV1o5oYQL'
            +'HUcwHRYmQzImgwMGCBhDRg+DGh+EAjI3PDwlDYMWhQExNjwvCpcABQcJBpf6'
            +'+4+BADs=')
     return img

def merge():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZlADyANT6DN0CGOUKIO0eGQ0+ZR1CQSlGbSVOeS1ebUFia'
            +'UViZU1WhTV+iWmOnXGesYG2wZ3Gya3a1b3q4dHy+doG9e4C/eoDBeoTDfkJ3'
            +'u1KEw1WGxl2KxV+MxlmKyF6Oy1+Py2OSzmSTzmiW0WqX0W6Z02+b1HKe1nSg'
            +'13Wh13qj2nqk2X2l3H6o3YfCgYnGgp3QlKHTmKXVnICp3YKq34Ss4Ieu4Yiv'
            +'4oyx44yy5Jq865u9652+656/7J/A7abD6aHB7qLB76nE6KrG6azH6KzG6azH'
            +'6q3H6q7I6K7J6rDI6LDJ6bDJ6rLL6rPM6rXM6LXN6rfO6rrP6rrQ67vQ677S'
            +'67/T69ji8Nvl8d7n8uLq9Obt9urw9+vx9+3y+O7z+e/z+fD0+vH2+vL2+/T3'
            +'+////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAGYA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB6mAZoKDhIVm'
            +'OTc1MywqhkBAPDpkk5MohUCUZC8YFxRkJoU9ZDIxMGWnZWQkhZKoP68/ZCKE'
            +'DAcKsESoXSCDCBUuBj9lQkRLS09ZHoIHEwkBBMREuadYG2YFEgOHY0llS9Lf'
            +'DwgOEQKCNWFLTk5SY6cNFxABgzVgUWVUTlH6CgMAhC3AUBk4rcyVDoVWCMR3'
            +'pWFDDoVQgOmyRYuGixczFDpRgoQIXoZCCgoEADs=')

     return img

def table_multiple():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZbAHy+doDBeoTDfkJ3u1KEw1SGxFWGxlaHx12KxVmKyF+P'
            +'y2OSzmSTzmiW0WqX0W6Z02+b1HKe1nSg13Wh13qj2n2l3H+o3InGgpPLi6HT'
            +'mKXVnICp3Yew2ouz3JK434Ss4IWs4Ieu4Yiv4oyx442y4oyy5I+05ZK25ZO2'
            +'5ZO355S355a455u/45i66Zm76Zu965y9652+656/7J+/7KTLxqTLyZ7B5Z/A'
            +'7aLE4aLD5qbD6aHB7qLB76rG6azH6KzG6ajG767I6K7J6rDI6LDJ6bLL6rPM'
            +'6rXM6K7K8Nji8Nvk8dvl8d7n8uXs9+bt9unv+Orw9+vx9+3y+O3z+e7z+vD0'
            +'+vD1+vH2+vL2+vT3+/X4+////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAFwA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB72AXIKDhIWD'
            +'PDcxKSUiHxsVFIU8WZRZWliVEoUyWTQ4NiweHRwkFpCDL1lIWlqWrFlPWZqC'
            +'LVkyVDU5PIqMjqcqWTFaQJXFlJomWC1UnBoZGBcCAQBZEFwiWCpaqVvd3ltZ'
            +'DlwcVSdUtTrp6jpZDFwUVClYKVk6Wz7fUQpcEQ8fTiWw9PjxwweRIUeYJBg0'
            +'QQoJLELufVtiYFCECB+oEDHio+MQH0kKFJIg5YmTJUlSpkRQqJ8DBgYIyJQ5'
            +'IBAAOw==')
     return img

def filtering():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPcAAMh/M81/OIF7c9mYP/LSOLmIScWIR9WOSMqTQMmWQ82X'
            +'Q8eaT9eiVcOsa8mvatCpYNK3Ztm0atm2eOe+Y+K7bfbWR/bZRvXZTfbbTurB'
            +'XvXcU/XYVfbaVffdW/LZXvbfX+zJb+zHfvDRfvbgavfic/jmfipgtyxity1k'
            +'uS5kuS5luTBlujBmujFmuzNpvDhxv1dmhlhkh0J5vzt2xDx4wUV+wkB8xGyD'
            +'l3aYqUKAxUWCxUaCxEaDxkeExkmFxEuIxUuJxUmIxkqIxkuJxkyJxk+Lx02L'
            +'yE+MyE+NyE+MyWSS22WU226sz1S191a091O0+FW0+H2w4X2y4ma38GW++2e9'
            +'/Gi//W7C/c23jM69ntS8k869rLLAtPDUgPTdifbigPnphvbimfjomtTFqefQ'
            +'qvjmofnuqfvwo4S24p7X/6DY/7PS8bXU87jW9LrW9bvW9bTY9rzZ9vvzycLb'
            +'9sHb+MLc+MTd+cXf+cff+sfg+sjg+cjg+sjg+8nh+8rh+sni+8vi+8zh+83j'
            +'+87j+8nl+s3j/M/j/M/k/M3m/Nfm8t/p9N/r9d7q9t7r9t/s99Dk+9Hk/NPl'
            +'/NPl/dLm/NPm/NPn/dTm/NTm/dXm/dXn/dbn/dXl/tbn/tfn/tbo/tfo/tjo'
            +'/uPt9+nv9ebw9+zy9+jx+Orx+Ovy+Ozy+O3z+Ozz+e30+O30+e70+O/0+fXz'
            +'8vD0+PD0+fH1+fL2+vP3+/P3/PT4/Pj7/fj7//3+/gAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAALoAIf8LSW1hZ2VNYWdpY2sKZ2FtbWE9'
            +'MC40NQAsAAAAABAAEAAACPMAdekycqSgwSJEZghc6INUq1anVEkklUjKkoW6'
            +'fszK4weQnzt03NiCE+WiQI2FBhUChKeOm1uICKGRcXJWykeFPsZRpIqWqBo1'
            +'K0WqhLOlGzZrZu0QGKTVp0hPKw26MwdLBDJLMzoFBeqpJDxZQMiZcENgD1Wf'
            +'uEZaOybDmS4hGAjcoQpqJFBCJZj5IkZEiQO6cpwSOvTRIy1eRojooGGALhuj'
            +'oDiB8oRJAwgeMGjYAEAgjVBW0qTh8iCMBgsIDByAIXAGaCpXHJQhUCEBjimv'
            +'WAh0IUpRI0UUwFxQsIWWrVwnFrJowYKFgAUFYqhQwSK5roAAOw==')
     return img

def importcsv():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAOe1ACpgtyxity5kth57AyxltC5luS9lujBluiJ7DjBmuiN6'
            +'HTFmuyV/ADNpvDhxvzWHCjt2xDx4wTuLETqMFUJ5vz98xEB8xEOPF0V+wkKA'
            +'xUKAxkiRG0mRHUWCxUWCxkaCxEaDxkeExkaULkmFxEqUMkmIxkqIxkuIxVGX'
            +'I0uJxUuJxkyJxleYKE2LyE+Lx0+MyE+MyU+NyFubKWOeMl6fOmOfMVygPGWf'
            +'MV+hQ2SS22miNmKjRmWU22ujN2ukQWalSG+kOmilRm+lPXKoRnSrT3yvVYGz'
            +'WoCzYYK1Z1W0+Fa091S194W2ZoW2aom4a32w4X2y4o66b5C8dIS24me9/GW+'
            +'+2i//ZbBgJfCgm7C/ZjCg57FiKHGiqHHiqXIjanKkKjLkKrLka3NlLDOlrPS'
            +'8Z7X/6DY/7XU87jW9LrW9bvW9bTY9rvY9rzZ9r3a9sHb+MLc+MTd+cXf+cff'
            +'+sfg+sjg+cjg+sjg+8nh+8rh+szh+8ni+8vi+83j+83j/M7j+8/j/Mnl+s/k'
            +'/NDk+9Hk/M3m/NPl/dLm/NXl/tPm/Nfm8tTm/NTm/dPn/dXn/dbn/dbn/tfn'
            +'/tbo/tfo/tjo/t/p9Nzq9t7q9t7r9t/r9d/s9+Pt9+nv9ebw9+jx+Orx+Ory'
            +'+uvy+Ozy9+zy+Ovz+uzz+e3z+O30+O30+e30+u70+O/0+e/0+vD0+PD0+fH1'
            +'+fL2+vP3+/j7+Pj7/fj7////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'/////////////////////yH+EUNyZWF0ZWQgd2l0aCBHSU1QACH5BAEKAP8A'
            +'LAAAAAAQABAAAAj+AP/9a/Gi4IsYMFykgCCw4QhRqk6ZmjhKlCIoPBr+OwGL'
            +'Dp49d+S8QUNrzZMcDVe88vOnD586cNLMKhRoCgWBKl4BGiTIT544bSqJisUJ'
            +'A05XiRY1ItTHDhw1Z8i0+iDQxKpIjxwxOqRnDhw3bFiBEFgCFSVKkyAZIqRn'
            +'yA04qTwIDFFK0qRHWQ0N8mGEBSgNAjuEgoRXCBAdM4qEIbKhgsAMnhAZMtRj'
            +'jJgwYKR0CfJAoIVOSZQsqSEmihMmR5BoscHgX4RNWcyUkfHFC5ctTbD8UCDQ'
            +'QSYrVKqg4HBBAo0rO0QQENjgkyZMlyxZIkVqAg4SsgA0PLAggfcDBgoHIBgg'
            +'IIDAgAA7')
     return img

def excel():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAOenACpgtyxity1kuS5kuS5luTN0GS9lujBlujN1GTN1GjN1'
            +'GzBmujFmuzFnuzNpvDd4HzZvvzhxv0F/LkJ/Ljt2wTt2xEWCNjx4wT9+f0iE'
            +'OkJ5vz98xUB8xEV+wkKAxlKKREWCxkaCxEaDxliNQ1iNRFaMVUmFxFOLb1mO'
            +'REmIwkuIxVuQR0uJxUyJxl2RSE2LyE+Lx1+TSk+MyE+MyWCTVU+NyFyWSWCW'
            +'S2OVVGSWV2aWU2SXUGWWV2SXUWKXYmaXWWiaZ2ubYWSS22WU23GeYXCeaG6g'
            +'W26hWXOgbHSkXWqrYXWuZ3G2XYOujYK2cX2w4ZC0kH2y4oS7eIe8c4TAaoS2'
            +'4orBbZW5oZXIdJfJdqHBsaPTgr7TtbTR6bPS8bXanLXU88PWu7jW9LrW9bTY'
            +'9sjZwLvY9sLZ5b3a9szcxcHb+M3dx8Pc9MLc+MPd+cXf+cbf+sff+sfg+sjg'
            +'+cjg+8ng+8zg9cjh+8nh+8vh+8zh+8ni+8vi+8zi/M3i/Mzj+83j+83j/M7j'
            +'+8nl+tDk+9Hk/M3m/Nfm8tzq9t7q9t7r9t/r9d/s9+Pt9+nv9ebw9+rx+Ory'
            +'+uzy9+zy+Ovz+u3z+O30+O30+u70+O/0+vD0+PH1+fL2+vL3+/P3+/P3/PT3'
            +'+/T4/PX5/Pf6/fj7/fj7//3+/v//////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'////////////////////////////////////////////////////////////'
            +'/////////////////////yH+EUNyZWF0ZWQgd2l0aCBHSU1QACH5BAEKAP8A'
            +'LAAAAAAQABAAAAj4AP/9eyGjoIwaM2CwqCCwoQlJmCxVmjhJ0qEoQxr+U8FJ'
            +'Dp49dN6oEVOKzBMhDVtsCiQIEJ85bcaQMjSoioZ/I0rowHGlyQQJGSxAkeTJ'
            +'UQecXL5gwREjyZEdPrqA8aIphMATZbZYwXGjBxA2bdCYySRCYAoiabJMGUHD'
            +'jh45btpcAiEQwwMXa6g4QaGF0J84cCJ5EKjAiI0Va5gsIaHATx48nTb8S5AA'
            +'QYEPQcJIUZKjT507oygI5PCoUKEzRXj8QGK6kCgIAi80ak27NagGAiMsql2b'
            +'lACBDiAxUpQIESJKlCJ9CmUKQMMDDBZIP2CAAIEBAwIIDAgAOw==')
     return img

def add():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZ2ADSBLDSCLDeELzmFMDyHMj2INECJNkKNNkKLOEOPOESM'
            +'OkeOPFOWRVCZQVeeRVaYSF2cTV+eUGajVmWrVWirU2mlWGuqWGyqWmqsW261'
            +'WG+1WG+1WXS3W3S3XHC4WXK5W3O6XHG+X3WsYXeuY3qvZXyxZ3i0ZHe8YHy6'
            +'ZH28Zn2+Z36yaX25an25a3+5bXm9bnDBY3nBZH7BaXzDa3rGa37Hb4CzaoO1'
            +'bYS2boe4cIe4cYm+eI2+e4HMdYrCeY/CfYbJeoXNeYbJfInIf4rPfYzLgY7M'
            +'hJLFgJfHhZfMhZjLhpjMh5PNiJjMio7Sg5bTiZTTipXUipbUi5fVi5nRi53Y'
            +'kqTOlKbPlqbQlqDZlaDZlqvUnKrUnaXbm6/fpa/fprPZpbTZpbTaprLbqLXb'
            +'qLfaqrPdqbTdqrbdrLXfrLjdr7vcr7fgr77itr3ktsvmw8XowM7pydTrz9fu'
            +'0tzx2ODy3P///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAHcA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB6SAd4KDhIWG'
            +'dzg2KyOHgzlWb3JxaC4VhzlrdW5dVWZwPhGFOWV0VUxGUVNObC4PhEhzWVBD'
            +'dnZBMjVsDoM3aF9FQi+1GCcgVEcLgittU0C1z3YeMlwIgiRnRD3QtR4qXAWC'
            +'Ik1QNDAT3B4eSTwDgxRnMSEn3BkdYgmEEixjxR4Z9WAuBCgEwUSZJSlQKBEj'
            +'8BCDBj+wWNlxYGCjOwkMEBBwseOgQAA7')
     return img

def cross():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAAOQiJOYqLOktL+ovMekyNes0Nuw8Pu49P+0+QO0/QfE/'
            +'Qe5AQu5BQ+9DRu9ER+9FSPJFR/BGSPBGSfRISvZKTPJMT/RNUPVOUPNRVPdV'
            +'V/9UV/ZVWPVWWPZWWf9WWfZYWvZYW/ZZW/ZaXPZaXfdbXfdcXv9YW/9bXvdd'
            +'YPdfYfheYfhfYvphY/9iY/hhZPhiZPpiZfljZvpjZvpkZ/9naPloavtpbPpq'
            +'bfxrbvpsbvttb/9sbvttcP9ucP9wcf9wcv9wc/1xdP5xdP9xdP9ydPxzdv10'
            +'d/90dv52ef92ef93ef93ev95e/15fP95fP95ff56ff96ff97fv98fv9+gP5+'
            +'gf9+gf+Chv+HigAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAFkA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB32AWYKDhIWG'
            +'h4dLS4YvNRiES1ZWQoQrPFMrhEJQWFA3gis3UCkShThCV0IvKTdMKQ+HMTxW'
            +'U0xLJQ6IWSNQJyZCDbpZJUseGj+liCMxQj89OxkGhyMvQh8MBhY0FgWF1D8Z'
            +'DIIEEC0UAoQbLBsIhAEKFAOFFe2FAPLC+fpZgQA7')
     return img

def accept():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPeGAB1sGh5uGh5wGh5xGh9xGx5zGh94Gx56Gx96Gx5/Gx+D'
            +'GyCKGyCIHC2WHC+WHDKdHUKpH0KrH0KtH0yXPUu0JlK5K1K7LVS7LVS9MVW+'
            +'NFXANFnCNlvCOU6bQVKgQl6pSGSwTGy2Vm23V2q5UG61WG+1WG+1WXC/V3S3'
            +'W3S3XHC4WXG5W3K5W3O6XHG+X323Zne8YHy6ZH28Zn2+Z3+4aXTCWW/CYW/D'
            +'YW7EYW7EYm7FY2/GZHDBY3HEY3TDZHDHZXPHZnnBZH7BaX7Hb3LIaHTIaHXI'
            +'aHbJaXbKannJa3rMbX/KcIO+bYfCcoXFdYnEdoDKc4DMcoPOd4fJeYvIeJDO'
            +'f5bHg5rHh5bLhpfMhZjLhprKh5jMh5bNiJnNip3Oi5nRi5nQjJrUjZ/SkZvX'
            +'kZ3YkqHWlaHXlaPXlqvSm6vTm6/XoK7Xoa7cpa/cprPZpbTZpbTaprHdp7Lb'
            +'qLXbqLTdqrTfrLXfrLXhrrfhr7fhsL7jtr/juMDkudbu0tns1Ob04+336/H5'
            +'8PT68vz9+/3+/f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAIcAIf8LSW1hZ2VNYWdpY2sKZ2FtbWE9'
            +'MC40NQAsAAAAABAAEAAACMEADwkcSLCgwUMcMFiocHDghhpo2rQ5M0LCQQ1V'
            +'8pSRIqVMnicPCmbIqMQIESNGkth50oDgiTxKiOyY2WPPkDwfBl44Q8bITBs2'
            +'+BgCBOYLA4EU5EQhksePjT2GCIURwiaBwAhtokARZChQ1C4sZqxBIBCCmTA+'
            +'pgwyZAhLCBZYrpAVCKJOEBdO/ngJQSJFnA4EHTSZA6MFCxIkULyhMaDgAiZx'
            +'uMSIsSVODAAHGXjgkiaNlQmYGx5CUAAAAdGoBwYEADs=')
     return img

def calculate():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZaAHJycnp6en5+fttYUuh0c01yp1Z7sGSLwWaNw2eNw2eP'
            +'xWiPxWmQxmuSyGyUym6VyoKDhIODhIaGhoaGh4aHh4eHh4eIiIiIiIiIiYiJ'
            +'iYqKiouMjI2NjYyNjo6Ojo+Pj5GRkZGRkpGSkpOTk5SUlJWVlZeXl5mZmZmZ'
            +'mpmampubm5ydnp2dnp6enp+goaCgoKKioqOjo6SkpKWlpaioqKmpqaurq6ys'
            +'rK2trbCwsLGxsbKysrS0tLu8vLy8vL+/v8HCwsLCwsXFxcnJyc7OztHR0dLS'
            +'0tPT09fX19jY2Nra2tvb29zc3N/f3+Dg4OHh4eLi4uPj4+Xl5ebm5ufn5+jo'
            +'6Onp6evr6/v7+/z8/P///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAFsA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB6mAW4KDhIWD'
            +'AC0zNjg4izMzLQKEJlqVlpcnhDBaBZ2enVothDNaBgcJCgsNDQZaMJqlqKoP'
            +'D60umlhKSEZEQ0JAP66wOB5KMxpEBANYooMrWlBQTEtIR0ZFWiuEJ1o7IVA4'
            +'H0w2HliZg5RUU1PRTk1MWiaEId0mVDsjUTkhWCGEG1quXLFShYq6KVo2EJIA'
            +'xIePHhAjApFAKEAEChg1aKBggQKEAIZCFgoEADs=')
     return img

def table_delete():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZ5ALlEA7lFA7xCBLxDBbxNBbxWHb1XHrhWIr5bKN1kAeFo'
            +'A+52AOp5Bfh2AO9/GP93Ef9/GMdlJ8prL9J2PeZ3IYRnaYttbny+dv+GIeuK'
            +'QP+STfSdY/WocoDBeoTDflKEw1WGxlaHx1mKyFuKyV6Oy1+Py2OSzmSTzmiW'
            +'0WqX0W6Z02+b1HKe1nSg13Wh13qj2nqk2X2l3H6o3beTib+Xi/a1jfe1jYnG'
            +'go7Jh5PLi5jOkJ3QlKHTmKXVnP7Nrv7WuICp3YKq34Ss4Ieu4Yiv4oyx44yy'
            +'5I+05ZC15pO355S355a66Zi66Zq865u9652+656/7J/A7abD6aHB7qLB76nE'
            +'6KrG6azH6KzG6a3H6azH6q7J6a7J6rDI6LDJ6bDJ6rLL6rPM6rXM6LfO6rrQ'
            +'67vQ673R677S67/T69ji8Nvk8dvl8d7n8t7n8+Lq9Obt9urw9+vx9+3y+O7z'
            +'+e/z+fD0+vH2+vL2+vT3+////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAHoA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB8SAeoKDhIWD'
            +'VFFPTktJSUZEQkAxL4JUeJeYd3eYeC2CUHg9PDs6OTg3Hh0XdyyCTnh5sbKz'
            +'eCmCTHhSuru8eCeCSrl5VrJYsnElgkd3VljOW11XXV1ibCKCRnhdeduxW7Jr'
            +'IIJEdF1h52FiVzMIAwYVgkJzY3llsjQTNT8cEoIyc2UCBjRzoIaGBxgyANAD'
            +'Y86ZPGZkCfAhy8EAPS3mwHnjhs2aNAU2YGiwQMFCFipSnCgxAsQHCxEoMEhA'
            +'wJAhAAMW6gkEADs=')
     return img

def function():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPUAACYmJikpKSoqKi0tLS4uLi8vLzExMTIyMjQ0NDU1NTc3'
            +'Nzo6OkBAQEVFRUdHR0hISElJSUxMTE5OTk9PT1FRUVJSUlVVVVZWVlhYWF1d'
            +'XWNjY2RkZGZmZmhoaGpqam1tbW9vb3JycnNzc3Z2dnd3d3t7e35+foGBgYuL'
            +'i5CQkJubm5+fn76+vgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAC0AIf8LSW1hZ2VNYWdp'
            +'Y2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAQABAAAAZEwJZwSCwaj8iTqVQSfTob'
            +'pIklckIzyBYqRcRkW6vod7hRjbuVc8uSPlsmkCEiCycSkJOGcGEgCJANDAsI'
            +'fQIAaoiJX0EAOw==')
     return img

def copy():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZtAEJzxUR0xUV1xkV1x0d5x0h9w0l5x0p5x0V1yEZ1yEt5'
            +'yE58yFN/ylCDylODylSAylKEylOFy1SFylWFy1SGy1WGy1aGy1eHy1KDzFOC'
            +'z1WDzFaBzlWGzFaGzFeHzFWFz1iHzFaIy1aIzFeIzF+WzGWVzW2e0Gyg0Yi7'
            +'6pG65JG75JK75JO75Ja+5Za/5pPB7J3D6q/R87TT9bvX9rzZ98Lc+cLc+sTd'
            +'+cTe+cXe/Mjf+sfg+8Ti+srg+svj+8zi+8vi/83i/M3j/N3p9dDk/NHk/NHl'
            +'/dLl/NLl/9Tm/dbn/dXn/tXn/9fn/9np/9vq/+fx7+jy7+Pv+uTv+ufw+ufy'
            +'+ufy/ejx+unx++vz+ury++vy++71++/2++jy/Onz/erz/ejz/uzz/O70/e31'
            +'/vD2/vH3/vD3//H3//L3//P4+/P5/v7//////wAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAG4A'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB7+ABBwjISES'
            +'EG6JiooSbWCPUlUoH4uKHGM5OzUyazwvBZVul0JCOzRDWWsloRJrRkY/NzAt'
            +'KionJiSKEWtKSkY9LY5gVVSSHG4RaExKTEUsmJqcO58QaE7XTM9CPqZDW2oY'
            +'GFxOT05KKmdGRbEzMlISG1Hk5iprTExGOjc0YCALw1O2bHl2T0kRHzasSDig'
            +'AMEAhxDOXDNnxMeaY5UwjJmHT8iYDaHicTQiJArISgcEBhQIZsyDUAAGyHT4'
            +'MACDQAA7')
     return img

def paste():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAAEZGRkhISElJSUpKSkxMTE9PT1JSUlNTU1VVVVZWVlhY'
            +'WFpaWl5eXmVlZWhoaGpqapVjJJhjIKFuLqR1N4FoSohzWJ+HaaCGY6GHZKGI'
            +'ZKmLYaGFaKOIbKWLb6eOcKSOdaqRc6yUdcaERM2HQ8eIR86LRsmMSs+OSNCP'
            +'SMuRTM2VT9uVQdyVQtyWQtyWQ9yXRNGTStKTS9GUS9OXTdOYTtSYTtqbSt6b'
            +'S9+dTs+ZUtWcUNWdUNacUNaeUdWeU9efUtegU9ejV9ikWNmlWtmnXNqoXtGf'
            +'YtelYtijYtikYtmmZNuqYdyrYtqoZd2uZdyraNyuad6yad6xa96ybN+zbduz'
            +'ceC0buC1cOG3c+K5duO7euS9fOS/fuS/f/DUdbOzs7S0tLW1tba2tre3t/Pb'
            +'gP3utf7vtubm5ufn5+jo6Onp6ezs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T0'
            +'9Pf39/j4+AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAHYA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB82AdoIRhIWC'
            +'h4eEE2VkZGUShIh2EVVcOGVeXmU4VFQRiBFcUTYvLyynP1GfiVxOS0SwsEA4'
            +'q4Narz+5P7NLtZNZREJAPxoYGRgcDQ4ODZNYQbk5IXRxcXBycnBzDBFYPzw1'
            +'KiBwY2Lm5m0LEVY8MzEpHnBqamlo9m0JEVAzMDAmHHLOgRm45oC+fiVEcHCT'
            +'Js0Ze2faFIjwBEWJESI2wBnIEcwaAhGSKFGSxMgHN/YgnlkjYFIhCBXovHnj'
            +'xs1MOQAkCVKA4EABAgQC5AwEADs=')
     return img

def tilevertical():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZrAEBZl0Bal0FbmEVenUZin0pnoUhlo0tnpUtpo01tpU1q'
            +'qE1qqlJxqFFwrlBxr1N0sVV2s1d5tll8sVl9uFp+uV2CvWGGumSFu2eLv2WL'
            +'xWySxGuVzG6XznKUwXmax22d2G+f2XGc0XWe1HWf13mgz36j0nih1n+n1XGg'
            +'2XOh2nSi2naj23ii2Xil232l2Xqm3Hun3Hym3H+o232o3X+q3Yiny4Op1oWt'
            +'2YGr3oSt34Wu34av34mv24ux3Y2y35C035W234iw4Imx4Iuy4Iyz4Y6y4I61'
            +'4Y+14omz5oq05oy1542254+355K24ZG14pC24pK34pO445S545W645++5JG4'
            +'6JK56JS66JW76Ze86Zi96Z3A6p7B66XC5KDC66HD66PE7KTE7KXF7KbG7KfG'
            +'7KjH7fv8/v39/v7+/v7+//7//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAGwA'
            +'LAAAAAAQABAAAAeUgGxsXVNSUD8+PDc2NjWCglRlZWKUYV6XXFwej1FRUFBG'
            +'RkQ+QkI5ORqPUGusra5rGI8+r65maxaPJbSvDI8ku64JjxJAOTgyLiYhIRwb'
            +'HQiPRFpZV1dVVUxMSkhIF484M+EvLSspKCgfHxOPMsCtEI8s7qwOjyPzawuP'
            +'GfgCjwUVJkR44GDBAQMEBgAA8Kihw4eBAAA7')

     return img

def tilehorizontal():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZTAEBZl0Bal0Jbl0NdmUNemkVgnEVgnUZinUlln0pnpEtp'
            +'ok9spk5tpk5rqFJwrVFyslZ3sVR2tVt/tld8uV+EuF+DvGGEu16EwWKIwGeM'
            +'wGOJxWeQyGuRyG6Yz3OUw3GXy3Wdz3efznOd03yi0Xih1nyk1X6m2n6p3YSi'
            +'yZCtz4Gp1Iar1oKp2Yat24Cr3YKq3IKs3oat34Wu34ev34iv2Iyx3omx4Iqy'
            +'4Iqy4Yyz4Y204Y+04I614pC24pG34pK24pO445S545W545e44pW645+94p++'
            +'5Ji96Zq+6py/6p3A6p/B66XC5KHD66TE7KXF7KfG7KjH7anI7f///wAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAFQA'
            +'LAAAAAAQABAAAAeEgFSCg4SFgkxENCsqKRZFOjYjISiCRlGXUU9OQ01LS0pH'
            +'Rx5URERAPjo6OzY2MTEwMCcZVD5Ttrcxt7cWVDu6ti+/UxJUNcImwhBULcIk'
            +'wg5ULMIiwg1UJcIdwglUIMIbwgZUH8IawgNUHMIXwgBUDBYWDAoIBgYTEQ8D'
            +'AvyG/v8ABwUCADs=')
     return img

def expand_col():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZvADp+NESHPUWGPkKIO1SOUF6VWVyiVF6rVF+hWGGiWmSv'
            +'W2q7X2yeaWmlZG+wZ2+xaHS2a3SzbHa0b3+8d3DCZHTHaIbDflFxqVFyqVNz'
            +'qVNzqlR1q1R1rFZ2rVd5rlh6sFh7sVp8slx+tFx+tV6Bt1+DuWCFumGFu2OH'
            +'vWSIvmaLwGiOw2+QwWySyGyUyW6Uym+Wy2+XzHqaxHCZznKaz3Oc0XOd0nWe'
            +'1Hag1Xmi2Hmj2Xqk2nqk23qm3Hun3IvGhZLLi5bMjprPkqPPnqfToqrXpbDd'
            +'qrHfq7TjrrjnsrnosoWs3Y2x3ZK56NHxzNLzzdP0z9bm1NT10Nb20db30df4'
            +'0tf40+D93OH+3eL+3uL/3uP/3uP/397n8uTq8+fu8ufr9ejs9urw9+vy9+zy'
            +'+O/z+vL1+/f7+fT4+/b6+/b7+/f8/Pn8/Pr9/fr+/v///wAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAHAA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB7+AcIKDhIWC'
            +'TD49Ozk4NzY0MzAuMoJLTZeYmZgscD6en6CgKnA8W1xZVUoVb6ytbyhwOqao'
            +'ShRvP19gXl1vJnA5plhWSQtvCg9jYmFvJHA4WlxYVEgWBxAODWVkbyNwN8FT'
            +'RxNCQUAJAmZvIXA1pldSRhIGEQgFaWhvH3Ax7lBFCFECEGizRs0bDnBeQLvy'
            +'hMiANwzOuHHD5o0GOC20aLniZAgAV60wwLmwQkWKEyVEhADhocOGDBcuGJpJ'
            +'s+agQAA7')
    return img

def contract_col():
    img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPZmACBeHSVlIixtJzp+NDx/N1SVTV2aV16XWVWhTVugU16p'
            +'VF6rVF+hWGOkW2WhX2SmXWKsWGapX2unZHG0aXS2a3G5aXW7bH68doPGe1Fx'
            +'qVFyqVNzqVNzqlR1q1R1rFZ2rVd5rlh6sFh7sVp8slx+tFx+tV6Bt1+DuWCF'
            +'umGFu2OHvWSIvmaLwGiOw2+QwWySyGyUyW6Uym+Wy2+XzHqaxHCZznKaz3Oc'
            +'0XOd0nWe1Hag1Xmi2Hmj2Xqk2nqk23qm3Hun3KS8o6a/pY7Ih5LLi5bMjqvF'
            +'qazEqq7JrLXPsrXSsrnWtbzauL/quoWs3Y2x3ZK56Nf80tj909r/1dv/1dv/'
            +'1tz/193/2N7/2d//2uTr4+Ts5OXs5ebu5efv5+nx6Ony6Orz6fr7+vr8+vv8'
            +'+/v9+////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAGcA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB7KAZ4KDhIWC'
            +'T0A/PTs6OTg2NTIwNIJOUJeYmZguZ0Cen6CgLGc+U1RVVlgLTGFlZq9mKmc8'
            +'plIYWAhLYK6wKGc7U1MVCk0NSl9ksGYmZzpTFhQXCRJJXmPKJWc5EBNFREMO'
            +'SF3JsCNnN1MRDwwDBkZb5K8hZzPBBQRZAkdcYsoeZzGCRTmQJYAQLfHMcDjz'
            +'IliVK1kABEGoTMOZDC1YrEhxgsQIESA+dNiQIYOhkyhTDgoEADs=')
    return img

def font():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAACtNwytQxDFVxjNhzDdjzDdmzDdnzTVpzzhozjlozjpq'
            +'zzptzzps0Tpz0z900z5300Jx0ER61UV61UJ+1kN+1k181VF+1kKA10CE2EGE'
            +'2EqD2EOJ2UOL2EeI2kmO2lCD11OG2FaG2VKL2lqJ2liM2l2P2laW3V6T216W'
            +'3GCP22CQ22uW3GOb3mid32qf33eg32yn4nGk4XGk4nCm4nWk4Xmm4Xqm4Xmn'
            +'4nOo4XOp43yp4oGo44Ku5Iu354+655G86QAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAEAA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB2OAQIKDhIWG'
            +'h4iDHB4cGBgNiUAwPz49MhSRJjk0Mw+RQDMdFDwMkSwoQAc6pYgXLoIDNRGJ'
            +'LiKCBzYgiCc1GgoJETshhw46BYMELyOHNCSFKyqFCSUqHwGCABAWFQKf3t/g'
            +'QIEAOw==')
     return img

def color_swatch():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPMAAP5va1DMbf+qc/DVZ1h6sP93sWCw69Drstmb3QAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAAkAIf8LSW1hZ2VNYWdpY2sKZ2FtbWE9'
            +'MC40NQAsAAAAABAAEAAABEAwyUmrvRboJHoaYKUBnAcO4tYJX4i90yEnQZ0Y'
            +'eCUftI0bulktcMvBYIRkAsFMFJ6VJGHZfBaiSibCCT16v+AIADs=')
     return img

def zoom_in():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAACprJi5vKTBxKzJ0LDN2LjV5MIdIKKVcM6tkN6tnN6tk'
            +'PT6DN0SLPU2WRVOeS1qbU1yoUl6rVF+tVmWnXmGwV2OyWWe2XGusY3a3bbmA'
            +'SLyFSryES7yDT7yGTL2GTL2JTL6JTb6KTb6KT7yEUcGOT8GPT8KPUMGOWMOR'
            +'UMORU8ORVsSVVcaWVceXV8aZVseaV8icV8mfW82kW8yhXc2lXs2mXs6mXs6n'
            +'XsmbYc2lYc6mYM6nYc6mYs+nYs+oYc+oZNe1fda1f4LCfYbFfdq7gIvGg4vH'
            +'hZDKiJrPkp7RlZ/Sl6bVnd7Ejd/Fj+DHk+PMmefToOjVo+nXpQAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAFMA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB36AU4KDhIWE'
            +'Nzo/PzMxhoM+N4QuLY4+MoYoKIU3kY4kIoQ6joOgg6KFFhQQU6WCp4QSSw5T'
            +'HoSNgxURGEkXDAuSlIIQSUhDR0UFhS0kgg4NE0YPAwGYrQtCA09NHIYbHh4b'
            +'BQIAUVJECqODJ01QTjgG6YIjQUEqCfGCBxn3U4EAOw==')
     return img

def zoom_out():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPYAAOoRHOwaI+4mLvE1OodIKKVcM6tkN6tnN6tkPbd+R/RF'
            +'SPdUVvpjYvxvbf54dLmASLyFSryES7uBTLyDT7yGTL2GTL2JTL6JTb6KTb6K'
            +'T7yEUcGOT8GPT8KPUMGMUsGOWMORUMORU8ORVsSVVcaWVceXV8aZVseaV8ic'
            +'V8mfW82kW8yhXc2lXs2mXs6mXs6nXsmbYc2lYc6mYM6nYc6mYs+nYs+oYc+o'
            +'ZNa0ede1fda1f9q7gNu/h/Ogm/SrpPa2rt7Ejd/Fj+DHk+PMmefToOjVo+nX'
            +'pffAt/jIvwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAEkA'
            +'If8LSW1hZ2VNYWdpY2sKZ2FtbWE9MC40NQAsAAAAABAAEAAAB3WASYKDhIWE'
            +'LzI3NysphoM2L4QmJY42KoYgIIUvkY4bGYQyjoOgg6KjSaWCp6MVhI2DDg0M'
            +'CwoDApKUgg1IRz8+PQGFJRyCtLYCAQCGn4QeOENAE4YQFRURCRM8RUY7CKiC'
            +'H0FEQjAE4EkaOTkfB+hJBQ/uSYEAOw==')
     return img

def save():
     img = tk.PhotoImage(format='gif',data=
             'R0lGODlhEAAQAPcAAIjAYjFgpjFgpzFgqDFhqDJhqDJhqTJhqjJiqjJiqzJj'
            +'rDNjrTNkrjNkrzNlsDRlsTRmsjRmszRntDVotTVotjVotzVptzVpuDVpuTVq'
            +'ujZqujdrujZquzZruzZrvDhruzhsuzptuzlsvDtuvT5wu16JyWSMyGWMyGWN'
            +'yWaNyWeOyWWNymmQymySy22Sy2iQzWqTz3mYx3yayHybyW2W03CZ1nGZ2HKb'
            +'2XOb2XOb2nKc23Sc2nSd3HSe3Xaf3XWe3naf3nef3neg3neg33ih4Hii4Hmi'
            +'4Xqi4Hqi4Xqj4Xuj4Xqi4nqj4nuj4nqj43uk4nqk43uk432m5n2n536o536o'
            +'6MLcv4GezISjzoqn0o6r1ZWw2pq13YCq6Z+64aS+5KnC563F6q3G67PK7bbM'
            +'7rjO77rQ7rvQ773Q7L7S8MPV78LV8sXY8sfZ9Mnc9Mzd9dDf9tHf9tHg9tHg'
            +'99jl9tnl99vm99vn99vn+N3o+N/p+N/p+eHs+eLs+ePt+eXt+ujw+unw+unx'
            +'+urw+urx++vx++3y++7z++70++70/O/0/PD1/PH2/PL2/PP3/fP4/fb5/fb6'
            +'/ff6/fb6/vf6/vf7/vj6/vj7/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
            +'AAAAAAAAAAAAAAAAAAAAACH5BAEAAJgAIf8LSW1hZ2VNYWdpY2sKZ2FtbWE9'
            +'MC40NQAsAAAAABAAEAAACP4AMXkY6KFDBw4cRIwI8YEEJoFy5lyqBGnRIEOQ'
            +'JBXSg6aEwDhdJkUycYhQo0uM+uAxg4aEBzhVGDEyIQiRJEiA8thJosaChzdU'
            +'AAFKEeiRJUV77tQpAoZCBzdT+PDxk0iSoz9K6Qj5IqFDGykmUKho4YLFCRNo'
            +'d3iJwIFNFCdQnjRRYmQIkB46eHB5wGGNEydNmjwxQkTIDx45cGxpwCENEyZJ'
            +'5hIJ4oPHDRs1tCzQcGbJpc+gQ9PIkuBDGSOUAKherRoSDCwHQJBBQsmK7du2'
            +'Ib24UmDDmCOpWa+GtGKGgAxiwoRefklGDAEaMFyoMEECBAcMFCAwMEBAAAIB'
            +'AQA7')
     return img
