import pygwalker as pyg

class PygwalkerStreamlitApp:
    def __init__(self, df):
        self.df = df

    def run(self):
        walker = pyg.walk(
            self.df,
            show_cloud_tool=False,            # set `show_cloud_tool=False`, pygwalker will not show the cloud tool.
            spec="./chart_meta_0.json",    # this json file will save your chart state, you need to click save button in ui mannual when you finish a chart, 'autosave' will be supported in the future.
            kernel_computation=True,          # set `kernel_computation=True`, pygwalker will use duckdb as computing engine, it support you explore bigger dataset(<=100GB).
        )


if __name__ == '__main__':

    import pandas as pd
    data = {"col1": [1, 2, 3], "col2": [4, 5, 1], "col3": ["A", "B", "A"]}
    df = pd.DataFrame(data)
    app = PygwalkerStreamlitApp(df)
    app.run()



    

 

